// Author: Sally Hudson
// This program estimates ATE using the Oaxaca-Blinder reweighting method described in Kline (2011).

capture program drop kline
program kline, eclass
	
	syntax varlist 
	
	preserve

	// parse command
	tokenize `varlist'
	tempvar y treatment 
	qui gen `y' = `1'
	qui gen `treatment' = `2'
	macro shift 2
	local covs `*'
	
	// verify that treatment is non-missing for all
	assert !missing(`treatment')
	
	// generate interactions between covariates and treatment
	forvalues d = 0/1 {
		local i = 1
		foreach v of varlist `covs' {
			gen d`d'v`i' = `v' * (`treatment' == `d')
			local ++i
		}
	}
	
	// regress outcome on full set of interactions
	qui reg `y' d?v*, nocons
	
	// initialize lincom string
	local lincom_str = "0"
	
	// loop over covs to generate lincom string
	local i = 1
	foreach v of varlist `covs' {
		quietly sum `v'
		local mu = r(mean)
		local lincom_str "`lincom_str' + (_b[d1v`i'] - _b[d0v`i'])*`mu'"
		local ++i
	}
	
	// get estimate
	display "Kline Estimate"
	lincom "`lincom_str'"
	local ate = r(estimate)
	local se = r(se)
	
	// return results
	ereturn scalar ate = `ate'
	ereturn scalar se = `se'
	restore
	
end

